;; Fitting common example dataset from:
;; Grasela and Donn (1985), Developmental 
;; Pharmacology and Therapeutics, 8, 374-383.
;; Description: Covariate model
;; 		Test WT on V
;; 		Test WT on CL
;;		Test Apgar on V
$PROB PPK Model for Phenobarbitol in neonates

$INPUT
ID TIME AMT WT APGR DV MDV EVID
$DATA data.csv IGNORE=@
$SUBROUTINE ADVAN1 TRANS2 

$PK
APGARLT5 = 0
IF (APGR < 5) APGARLT5 = 1

TVCL = THETA(1)*((WT/1.5)**THETA(5))
CL = TVCL*EXP(ETA(1))

TVV = THETA(2)*((WT/1.5)**THETA(4))*(1 + APGARLT5*THETA(4))
V = TVV*EXP(ETA(2))

S1 = V
RUVADD = THETA(3)

$ERROR
IPRED = F
 
W = RUVADD
 
Y =  IPRED+W*EPS(1)
IRES = DV - IPRED
IWRES = IRES/W

$THETA
(0, 0.01) ; CL
(0, 1) ; V
(0, 0.1) ; RUVADD

$THETA
0.1 ; WT~V
0.1 ; WT~CL
(-1, 0.1) ; Apgar~V

$OMEGA BLOCK(2)
1 ; IIVCL
0.1 1 ; IIVV

$SIGMA
1 FIX


$ESTIMATION METHOD=1 INTER MAXEVAL=9999 PRINT=1
$COV	PRINT=E UNCONDITIONAL

; Monolithic table
$TAB ID TIME AMT WT APGR MDV EVID IPRED IRES IWRES
	 CL V ETAS(1:LAST) 
	 PRED CRES CWRES NPDE NOPRINT FORMAT=s1PE13.7 
	 FILE=run15tab